/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.shop;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.shop.MaterialQuantity;
import cz.insophy.inplan.shop.Product;
import cz.insophy.inplan.util.Triple;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;

public class LocalAlternativeGroup
implements Iterable<Action> {
    private final List<Action> actions;

    private LocalAlternativeGroup(Builder bob) {
        this.actions = ImmutableList.copyOf(bob.actions);
    }

    @Override
    public Iterator<Action> iterator() {
        return this.actions.iterator();
    }

    protected List<Action> getActions() {
        return this.actions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<Action> actions = Lists.newArrayList();
        private boolean built;

        private Builder() {
        }

        public void addAction(Action action) {
            this.actions.add(action);
        }

        @Nonnull
        public String isValid() {
            for (int i = 0; i < this.actions.size(); ++i) {
                for (int j = i + 1; j < this.actions.size(); ++j) {
                    if (!this.actions.get(i).getLocalAltName().equals(this.actions.get(j).getLocalAltName())) continue;
                    return String.format("There are duplicate local alternative names %s in LAG.", this.actions.get(i).getLocalAltName());
                }
            }
            if (this.actions.isEmpty()) {
                return "There are no actions in the LAG.";
            }
            HashSet<MaterialQuantity> mainBomProductSet = null;
            for (Action action : this.actions) {
                HashSet<MaterialQuantity> hashSet = Sets.newHashSet();
                for (MaterialQuantity mq : action.getBom()) {
                    if (!(mq.getMaterial() instanceof Product)) continue;
                    hashSet.add(mq);
                }
                if (mainBomProductSet == null) {
                    mainBomProductSet = hashSet;
                    continue;
                }
                if (hashSet.equals(mainBomProductSet)) continue;
                return "Products in BOMs differ in LAG.";
            }
            HashSet<MaterialQuantity> mainProducingSet = null;
            for (Action action : this.actions) {
                HashSet<MaterialQuantity> producingSet = Sets.newHashSet(action.getProduces());
                if (mainProducingSet == null) {
                    mainProducingSet = producingSet;
                    continue;
                }
                if (producingSet.equals(mainProducingSet)) continue;
                return "Produced items differ in LAG.";
            }
            List<Triple<String, Double, Double>> list = this.actions.get(0).getProducesNames();
            for (Action alt : this.actions.subList(1, this.actions.size())) {
                if (Objects.equal(list, alt.getProducesNames())) continue;
                return "Unresolved produced items differ in LAG.";
            }
            double d = this.actions.get(0).getQtyCoef();
            for (Action alt : this.actions.subList(1, this.actions.size())) {
                if (alt.getQtyCoef() == d) continue;
                return "qtyCoefs differ in LAG.";
            }
            return "";
        }

        public Action build() {
            Preconditions.checkState(!this.built, "can only build once per group");
            String err = this.isValid();
            Preconditions.checkState(Strings.isNullOrEmpty(err), err);
            LocalAlternativeGroup lag = new LocalAlternativeGroup(this);
            for (Action a : lag) {
                a.makeMemberOfLag(lag);
            }
            this.built = true;
            return lag.actions.get(0);
        }

        public void reset() {
            this.actions.clear();
            this.built = false;
        }
    }
}

